<?php 
ob_start();
session_start();
date_default_timezone_set('Asia/Ho_Chi_Minh');

require("Connection.php");

// 1. Lấy dữ liệu Input
$thang = isset($_POST["thang"]) ? (int)$_POST["thang"] : (int)date('m');
$nam = isset($_POST["nam"]) ? (int)$_POST["nam"] : (int)date('Y');
$sohs = isset($_POST["sohs"]) ? (int)$_POST["sohs"] : 0;

// 2. Query dữ liệu
// Join bảng dexuatgiaotrinh, lopmn, truongmn để lấy đủ thông tin
$sql1 = "SELECT a.*, b.tenlopmn, c.diachi 
         FROM dexuatgiaotrinh a, lopmn b, truongmn c 
         WHERE a.malopmn=b.malopmn AND a.matruongmn=c.matruongmn 
         AND a.soluongbe >= " . $sohs . " 
         AND month(a.ngaydexuat) = " . $thang . " 
         AND year(a.ngaydexuat) = " . $nam . " 
         ORDER BY c.diachi, a.soluongbe DESC LIMIT 0, 3000";

// FIX: mysqli_query
$result1 = mysqli_query($link, $sql1);
$tongrec1 = ($result1) ? mysqli_num_rows($result1) : 0;
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<HTML>
<HEAD>
    <Title>Admin</Title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <style type="text/css">
        .style3 {
            font-size: 14pt;
            font-family: Arial, Helvetica, sans-serif;
            color: #990000;
            font-weight: bold;
        }
    </style>
</HEAD>
<body>
    <form name="f1" method="POST" action="thongkelop.php">
        <div align="center">
            <p><font color="#FF0000" size="+2"><b><br />THỐNG KÊ GIÁO TRÌNH THEO LỚP</b></font><br /><br /></p>
        </div>
        
        <div align="center">
            <table width="700" border="1" align="center" cellpadding="2" cellspacing="0">
                <tr>
                    <td width="70" align="right"><strong>Tháng :</strong></td>
                    <td width="59">
                        <strong>
                            <select name="thang">
                                <?php 
                                for ($m = 1; $m <= 12; $m++) {
                                    $selected = ($m == $thang) ? "selected" : "";
                                    echo "<option value='$m' $selected>$m</option>";
                                }
                                ?>
                            </select>
                        </strong>
                    </td>
                    <td width="48" align="right"><strong>Năm :</strong></td>
                    <td width="360">
                        <strong>
                            <select name="nam">
                                <?php 
                                $currentYear = (int)date('Y');
                                for ($y = 2023; $y <= $currentYear + 2; $y++) {
                                    $selected = ($y == $nam) ? "selected" : "";
                                    echo "<option value='$y' $selected>$y</option>";
                                }
                                ?>
                            </select>
                            Số HS từ : 
                            <label for="sohs"></label>
                            <input type="text" name="sohs" value="<?php echo $sohs;?>" size="5"/> 
                        </strong>
                    </td>
                    <td width="131">
                        <strong><input type="submit" value="thống kê" name="cmd1" /></strong>
                    </td>
                </tr>
            </table>
            
            <br /><br />
            
            <table width="100%" cellspacing="0" class="khungbao1">
                <tr>
                    <td width="13%" align="center" class="dkta1"><p align="center"><font color="#800000" face="Arial" size="2">Trường</font></p></td>
                    <td width="11%" align="center" class="dkta1"><p align="center"><font color="#800000" face="Arial" size="2">Lớp</font></p></td>
                    <td width="16%" align="center" class="dkta1"><p align="center"><font color="#800000" face="Arial" size="2">Số lượng bé</font></p></td>
                    <td width="27%" align="center" class="dkta1"><p align="center"><font color="#800000" face="Arial" size="2">Giáo trình đã đề xuất</font></p></td>
                    <td width="14%" align="center" class="dkta1"><p align="center"><font color="#800000" size="2" face="Arial">Người đề xuất</font></p></td>
                    <td width="19%" align="center" class="dkta1"><p align="center"><font color="#800000" face="Arial" size="2">Ngày đề xuất</font></p></td>
                </tr>
                <?php
                $sott = 0;
                if ($tongrec1 > 0) {
                    while ($row = mysqli_fetch_array($result1)) {   
                        $sott++;
                        // $malopmn = $row["malopmn"]; // Biến này không dùng để hiển thị, có thể bỏ
                ?>
                        <tr>
                            <td align="center" class="dkta1"><div align="center">&nbsp;<font face="arial" size="2"><?php echo $row["diachi"];?></font></div></td>
                            <td align="center" class="dkta1"><div align="center"><font face="arial" size="2"><?php echo $row["tenlopmn"];?></font>&nbsp;</div></td>
                            <td align="center" class="dkta1"><div align="center"><font face="arial" size="2"><?php echo $row["soluongbe"];?></font>&nbsp;</div></td>
                            <td align="center" class="dkta1"><div align="center"><font face="arial" size="2"><?php echo $row["noidungdx"];?></font>&nbsp;</div></td>
                            <td align="center" class="dkta1"><div align="center"><font face="arial" size="2"><?php echo $row["nguoidx"];?></font>&nbsp;</div></td>
                            <td align="center" class="dkta1"><div align="center"><font face="arial" size="2">
                                <?php 
                                    // Format ngày tháng hiển thị cho đẹp (d/m/Y)
                                    echo date("d/m/Y H:i", strtotime($row["ngaydexuat"]));
                                    // echo " " . $sott; // Số thứ tự nếu cần
                                ?>
                            </font></div></td>
                        </tr>
                <?php 
                    }
                } else {
                    echo "<tr><td colspan='6' align='center'>Không tìm thấy dữ liệu</td></tr>";
                }
                ?>
            </table>
            <p><br /></p>
        </div>
    </form>
</body>
</HTML>

<script language="javascript">
    function kt() {
        if (document.f1.thang.value == "") {
            alert("Sao khong chon thang?!");
            return false;
        }
        if (document.f1.nam.value == "") {
            alert("Chon nam chua?!");
            return false;
        }
        
        document.f1.action = "thongkelop.php"; // Submit về chính trang này
        document.f1.submit();
    }
</script>