<?php 
ob_start();
session_start();
date_default_timezone_set('Asia/Ho_Chi_Minh');

require("Connection.php");

// 1. Lấy dữ liệu chung
$matrmn_raw = isset($_POST["mtmn"]) ? $_POST["mtmn"] : "";
$malop_raw = isset($_POST["khoilop"]) ? $_POST["khoilop"] : "";
$soluong_raw = isset($_POST["soluongbe"]) ? $_POST["soluongbe"] : 0;
$nguoidx_raw = isset($_POST["nguoidx"]) ? $_POST["nguoidx"] : "";
$ghichu_raw = isset($_POST["ghichu"]) ? $_POST["ghichu"] : "";
$ngaydx = date("Y-m-d H:i:s");

// Escape dữ liệu
$matrmn = mysqli_real_escape_string($link, $matrmn_raw);
$malop = (int)$malop_raw; // Ép kiểu số
$soluong = (int)$soluong_raw; // Ép kiểu số
$nguoidx = mysqli_real_escape_string($link, $nguoidx_raw);
$ghichu = mysqli_real_escape_string($link, $ghichu_raw);

$chuoidx = ""; // Biến chứa chuỗi tổng hợp để lưu vào bảng dexuatgiaotrinh

// Chỉ xử lý nếu dữ liệu hợp lệ
if ($malop > 0 && $soluong > 0 && $nguoidx != "") {
    
    // Mảng các tiền tố của input name (khớp với file dexuatgiaotrinhnew.php)
    // Ví dụ: k3a1 -> k3a10, k2b1 -> k2b10...
    $prefixes = ['k3a', 'k2b', 'k1c', 'l', 'd', 'n'];
    
    // Duyệt qua từng loại mã (K3A, K2B...)
    foreach ($prefixes as $prefix) {
        // Duyệt từ 1 đến 10 (vì mỗi loại có 10 ô select)
        for ($i = 1; $i <= 10; $i++) {
            $inputName = $prefix . $i; // VD: k3a1, k3a2...
            
            // Lấy giá trị từ POST
            $maGT = isset($_POST[$inputName]) ? $_POST[$inputName] : "";
            
            if ($maGT != "") {
                $maGT_safe = mysqli_real_escape_string($link, $maGT);
                
                // 1. Cộng dồn vào chuỗi tổng hợp
                $chuoidx .= $maGT_safe . ", ";
                
                // 2. Insert vào bảng chi tiết (solieugt)
                $sql2 = "INSERT INTO solieugt(matruongmn, malopmn, magt, solg, ngaydx) 
                         VALUES ('$matrmn', $malop, '$maGT_safe', $soluong, '$ngaydx')";
                mysqli_query($link, $sql2);
            }
        }
    }

    // Sau khi duyệt hết tất cả các ô select
    if ($chuoidx != "" || $ghichu != "") {
        // Thêm ghi chú vào cuối chuỗi (nếu có)
        if ($ghichu != "") {
            $chuoidx .= " Ghi chú: " . $ghichu;
        }
        
        // Cắt bỏ dấu phẩy thừa ở cuối nếu không có ghi chú và chuỗi không rỗng
        if ($ghichu == "" && strlen($chuoidx) > 2) {
            $chuoidx = substr($chuoidx, 0, -2);
        }

        // Insert vào bảng tổng hợp (dexuatgiaotrinh)
        $chuoidx_safe = mysqli_real_escape_string($link, $chuoidx);
        
        $sql3 = "INSERT INTO dexuatgiaotrinh(matruongmn, malopmn, soluongbe, ngaydexuat, noidungdx, nguoidx) 
                 VALUES ('$matrmn', $malop, $soluong, '$ngaydx', '$chuoidx_safe', '$nguoidx')";
        
        mysqli_query($link, $sql3);
    }
}

// Redirect về trang danh sách
header("location:dexuatgiaotrinhnew.php#xemgt");
ob_end_flush();
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<HTML>
    <HEAD>
        <Title>Mainspring School Admin</Title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <style type="text/css">
        .style3 {
            font-size: 14pt;
            font-family: Arial, Helvetica, sans-serif;
            color: #990000;
            font-weight: bold;
        }
        </style>
    </HEAD>
    <body>
        <span class="style3"> Cập nhật thành công. <a href="dexuatgiaotrinhnew.php#xemgt">Trở về</a></span>
    </body>
</HTML>