<?php
date_default_timezone_set('Asia/Ho_Chi_Minh');
require("Connection.php");

// 1. Lấy danh sách trường để tạo vòng lặp
$sql1 = "SELECT * FROM truongmn";

// FIX: mysqli + đảo tham số ($link lên trước)
$result1 = mysqli_query($link, $sql1);

if ($result1 && mysqli_num_rows($result1) > 0) {
    while ($row1 = mysqli_fetch_array($result1)) {
        $matruong = $row1["matruongmn"];

        // 2. Lấy dữ liệu động từ form dựa trên ID trường
        // Code cũ dùng @$_POST, tớ sửa thành isset để chuẩn PHP 8
        
        $nvpt_key = "nvpt" . $matruong;
        $nvpt = isset($_POST[$nvpt_key]) ? $_POST[$nvpt_key] : "";

        $slmn_key = "solopmn" . $matruong;
        $slmn = isset($_POST[$slmn_key]) ? $_POST[$slmn_key] : 0;

        $slnt_key = "solopnt" . $matruong;
        $slnt = isset($_POST[$slnt_key]) ? $_POST[$slnt_key] : 0;

        $tsolop_key = "tongsolop" . $matruong;
        $tsolop = isset($_POST[$tsolop_key]) ? $_POST[$tsolop_key] : 0;

        $hd_key = "hopdong" . $matruong;
        $hd = isset($_POST[$hd_key]) ? $_POST[$hd_key] : "";

        // FIX QUAN TRỌNG: Escape dữ liệu chuỗi để tránh lỗi SQL khi có ký tự đặc biệt
        $nvpt_safe = mysqli_real_escape_string($link, $nvpt);
        $hd_safe = mysqli_real_escape_string($link, $hd);
        $matruong_safe = mysqli_real_escape_string($link, $matruong);
        
        // Convert số sang int cho an toàn
        $slmn = (int)$slmn;
        $slnt = (int)$slnt;
        $tsolop = (int)$tsolop;

        // Logic cũ: Chỉ update nếu có chọn nhân viên (nvpt <> "")
        // Nếu bạn muốn cho phép XÓA nhân viên (chọn rỗng) thì bỏ điều kiện if này đi nhé.
        if ($nvpt <> "") {
            $sql2 = "UPDATE truongmn SET 
                     nhanvien = '" . $nvpt_safe . "',
                     hopdong = '" . $hd_safe . "', 
                     solopmn = " . $slmn . ",
                     solopnt = " . $slnt . ",
                     tongsolop = " . $tsolop . " 
                     WHERE matruongmn = '" . $matruong_safe . "'";

            // FIX: mysqli + đảo tham số
            mysqli_query($link, $sql2);
        }
    }
}
?>

<script language="javascript">
    // FIX: Đổi tc=1 thành tc=10 để khớp với file nhanvientruong.php (hiện alert thành công)
    window.location.href = "nhanvientruong.php?tc=10";
</script>