<?php 
ob_start();
session_start();
date_default_timezone_set('Asia/Ho_Chi_Minh');

require("Connection.php");

// --- BUGTRAP: Tắt báo lỗi Fatal của MySQLi để xử lý thủ công ---
mysqli_report(MYSQLI_REPORT_OFF);

// 1. Lấy dữ liệu Input
$thang = isset($_POST["thang"]) ? (int)$_POST["thang"] : (int)date('m');
$nam = isset($_POST["nam"]) ? (int)$_POST["nam"] : (int)date('Y');

// 2. Xóa dữ liệu cũ (Reset bảng tạm)
$sql10 = "DELETE FROM solieugt";
mysqli_query($link, $sql10);

// 3. Lấy danh sách đề xuất
$sql1 = "SELECT * FROM dexuatgiaotrinh WHERE month(ngaydexuat)=" . $thang . " AND year(ngaydexuat)=" . $nam;
$result1 = mysqli_query($link, $sql1);

if ($result1 && mysqli_num_rows($result1) > 0) {
    while ($row1 = mysqli_fetch_array($result1)) {   
        $matruongmn = $row1["matruongmn"];
        $malopmn = $row1["malopmn"];
        $soluongbe = (int)$row1["soluongbe"];
        $noidungdx = $row1["noidungdx"];
        $ngaydexuat = $row1["ngaydexuat"];
        
        // --- LOGIC TÁCH CHUỖI & BUGTRAP ---
        $len = strlen($noidungdx);
        for ($i = 0; $i < $len; $i++) {
            $kytu = substr($noidungdx, $i, 1);
            $kytu_upper = strtoupper($kytu);
            $mabai = "";
            $jump = 0;

            // Case 1: Mã bắt đầu bằng K (Lấy 6 ký tự)
            if ($kytu_upper == "K") {
                $mabai = substr($noidungdx, $i, 6);
                $jump = 6;
            }
            
            // Case 2: Mã bắt đầu bằng L, D, N (Lấy 4 ký tự)
            elseif ($kytu_upper == "L" || $kytu_upper == "D" || $kytu_upper == "N") {
                $mabai = substr($noidungdx, $i, 4);
                $jump = 4;
            }

            // Nếu tìm thấy Mã bài -> Thực hiện Insert an toàn
            if ($mabai != "") {
                // --- FIX: Cắt chuỗi cứng để không vượt quá 10 ký tự (Tránh lỗi Data too long) ---
                if (strlen($mabai) > 10) {
                    $mabai = substr($mabai, 0, 10);
                }
                
                // Escape dữ liệu an toàn
                $mabai_safe = mysqli_real_escape_string($link, $mabai);
                $matruongmn_safe = mysqli_real_escape_string($link, $matruongmn);
                $ngaydexuat_safe = mysqli_real_escape_string($link, $ngaydexuat);

                $sql2 = "INSERT INTO solieugt(matruongmn, malopmn, magt, solg, ngaydx) VALUES ";
                $sql2 .= "('".$matruongmn_safe."', ".$malopmn.", '".$mabai_safe."', ".$soluongbe.", '".$ngaydexuat_safe."')";  
                
                // Thực thi Query có kiểm tra lỗi (Silent Mode)
                if (!mysqli_query($link, $sql2)) {
                    // Nếu lỗi (ví dụ trùng khóa chính, hoặc data vẫn lỗi), ta ghi log và bỏ qua
                    // error_log("Lỗi insert solieugt: " . mysqli_error($link));
                }

                // Nhảy cóc qua mã vừa tìm thấy (trừ 1 vì vòng for sẽ tự cộng 1)
                $i = $i + $jump - 1; 
            }
        }
    }
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<HTML>
<HEAD>
    <Title>Mainspring School Admin</Title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <style type="text/css">
        .style3 {
            font-size: 14pt;
            font-family: Arial, Helvetica, sans-serif;
            color: #990000;
            font-weight: bold;
        }
    </style>
</HEAD>
<body>
    <form name="f1" method="POST" action="xulythongke.php">
        <div align="center">
            <p><font color="#FF0000" size="+2"><b><br />THỐNG KÊ GIÁO TRÌNH</b></font><br /><br /></p>
        </div>
        
        <div align="center">
            <table width="700" border="1" align="center" cellpadding="2" cellspacing="0">
                <tr>
                    <td width="101" align="right"><strong>Chọn tháng :</strong></td>
                    <td width="93">
                        <strong>
                            <select name="thang">
                                <?php 
                                for ($m = 1; $m <= 12; $m++) {
                                    $selected = ($m == $thang) ? "selected" : "";
                                    echo "<option value='$m' $selected>$m</option>";
                                }
                                ?>
                            </select>
                        </strong>
                    </td>
                    <td width="141" align="right"><strong>Chọn năm :</strong></td>
                    <td width="136">
                        <strong>
                            <select name="nam">
                                <?php 
                                $currentYear = (int)date('Y');
                                for ($y = 2017; $y <= $currentYear + 1; $y++) {
                                    $selected = ($y == $nam) ? "selected" : "";
                                    echo "<option value='$y' $selected>$y</option>";
                                }
                                ?>
                            </select>
                        </strong>
                    </td>
                    <td width="217">
                        <strong><input type="submit" value="thống kê" name="cmd1" /></strong>
                    </td>
                </tr>
            </table>

            <p><br />
                <strong><font color="#000066" size="+1">Tháng : <?php echo $thang; ?> Năm: <?php echo $nam; ?></font></strong>
            </p>

            <table width="32%" cellspacing="0" border="1">
                <tr>
                    <td width="55%" align="center"><p align="center"><font color="#800000" face="Arial" size="2">MÃ GIÁO TRÌNH</font></p></td>
                    <td width="45%" align="center"><p align="center"><font color="#800000" size="2" face="Arial">SỐ LƯỢNG</font></p></td>
                </tr>
                <?php
                // Query tổng hợp
                $sql5 = "SELECT magt, sum(solg) soluonggt FROM solieugt WHERE month(ngaydx)=" . $thang . " AND year(ngaydx)=" . $nam ." GROUP BY magt ORDER BY soluonggt DESC";
                
                $result5 = mysqli_query($link, $sql5);
                
                if ($result5 && mysqli_num_rows($result5) > 0) {
                    while ($row5 = mysqli_fetch_array($result5)) {
                ?>
                    <tr>
                        <td align="center"><div align="center"><font face="arial" size="2"><?php echo $row5["magt"]; ?></font>&nbsp;</div></td>
                        <td align="center"><div align="center"><font face="arial" size="2"><?php echo $row5["soluonggt"]; ?></font>&nbsp;</div></td>
                    </tr>
                <?php
                    }
                }
                ?>
            </table>
            <p><br /></p>
        </div>
    </form>
</body>
</HTML>